<?php
namespace ElementPress\Modules\Megamenu;

defined( 'ABSPATH' ) || exit;
class Init{
	public $dir;
	public $url;
	public static $menuitem_settings_key = 'elementpress_menuitem_settings';
	public static $megamenu_settings_key = 'megamenu_settings';
    public function __construct(){

		wp_enqueue_style( 'elementpress-css-icon-control',  \ElementPress::module_url() . 'controls/assets/css/epressicons.css', [], \ElementPress::version  );
        // get current directory path
        $this->dir = dirname(__FILE__) . '/';
        // get current module's url
		$this->url = \ElementPress::plugin_url() . 'modules/megamenu/';
		// enqueue scripts
		add_action( 'admin_enqueue_scripts', [$this, 'enqueue_styles'] );
		add_action( 'admin_enqueue_scripts', [$this, 'enqueue_scripts'] );
		// include all necessary files
		$this->include_files();
		new Options();
	}
	public function include_files(){

		include $this->dir . 'api.php';
		//include \ElementPress::widgets_dir() . 'nav-menu\classes\walker-nav-menu.php';
	}
	public function enqueue_styles() {
		$screen = get_current_screen();
		if($screen->base == 'nav-menus'){
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_style( 'elementpress-css-icon-control',  \ElementPress::module_url() . 'controls/assets/css/epressicons.css', [], \ElementPress::version  );
			//wp_enqueue_style( 'elementpress-css-megamnu-navi-style',  \ElementPress::widgets_url() . 'nav-menu/assets/css/style.css', [], \ElementPress::version  );
			wp_enqueue_style( 'fonticonpicker', $this->url . 'assets/css/jquery.fonticonpicker.css', false, \ElementPress::version );
			wp_enqueue_style( 'elementpress-menu-admin-style', $this->url . 'assets/css/admin-style.css', false, \ElementPress::version );
		}
	}
	public function enqueue_scripts(){
		$screen = get_current_screen();
		if($screen->base == 'nav-menus'){
			wp_enqueue_script( 'fonticonpicker', $this->url . 'assets/js/jquery.fonticonpicker.min.js', array( 'jquery'), false, true );
			wp_enqueue_script( 'elementpress-menu-admin-script', $this->url . 'assets/js/admin-script.js', array( 'jquery', 'wp-color-picker' ), false, true );
		}
	}
}