<?php
namespace ElementPress\Modules\Controls;
defined( 'ABSPATH' ) || exit;
class Icon extends \Elementor\Base_Data_Control {
	public function get_type() {
		return 'icon';
	}
	public static function get_url(){
        return \ElementPress::module_url() . 'controls/';
    }
    public static function get_dir(){
        return \ElementPress::module_dir() . 'controls/';
    }
	public function enqueue() {
		// styles
		wp_register_style( 'elementpress-css-icon-control',  Icon::get_url() . 'assets/css/epressicons.css', [], '1.0.1' );
		wp_enqueue_style( 'elementpress-css-icon-control' );
    }
	public static function get_icons() {
    return include Icon::get_dir() . 'icon-list.php';
	}
	protected function get_default_settings() {
		return [
			'options' => self::get_icons(),
		];
	}
	public function content_template() {
		?>
		<div class="elementor-control-field">
			<label class="elementor-control-title">{{{ data.label }}}</label>
			<div class="elementor-control-input-wrapper">
				<select class="elementor-control-icon" data-setting="{{ data.name }}" data-placeholder="<?php esc_attr_e( 'Select Icon', 'elementpress-hederfooter' ); ?>">
					<option value=""><?php esc_html_e( 'Select Icon', 'elementpress-hederfooter' ); ?></option>
					<# _.each( data.options, function( option_title, option_value ) { #>
					<option value="{{ option_value }}">{{{ option_title }}}</option>
					<# } ); #>
				</select>
			</div>
		</div>
		<# if ( data.description ) { #>
		<div class="elementor-control-field-description">{{ data.description }}</div>
		<# } #>
		<?php
	}
}
