<?php
namespace Elementor;
use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;
class Elementpress_Widget_postcoments extends Widget_Base {
	public $base;
    public function get_name() {
		//get name from postcoments-handler file
		return 'elementpress-postcoments';
    }
    public function get_title() {
		//get title from postcoments-handler file
		return esc_html__( 'Post Comments', 'elementpress' );
    }
    public function get_icon() {
		//get icon from postcoments-handler file
        return 'eicon-comments';
    }
    public function get_categories() {
		//get category from postcoments-handler file
		return [ 'elementpress_singlepost' ];
	}
	//register controls
    protected function register_controls() {
		//Single Post Comment section inside Post Comment widget
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Single Post Comment', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		//controls inside single post comment secrtion
		//number box
		$this->add_control(
			'per_page_coment',
			[
				'label' => __( 'Comment Per Page', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 0,
			]
		);
		//number box
		$this->add_control(
			'coment_page_ref',
			[
				'label' => __( 'Comment Page ', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 0,
			]
		);
		//show reply switcher
		$this->add_control(
				'show_reply',
				[
					'label' => __( 'Show Reply', 'elementpress' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => __( 'Show', 'elementpress' ),
					'label_off' => __( 'Hide', 'elementpress' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			//control for alignment
        $this->add_control(
			'title_align',
			[
				'label' => __( 'Alignment', 'elementpress' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'elementpress' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'elementpress' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'elementpress' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'left',
				'selectors' => [
					'{{WRAPPER}} .coment_list,{{WRAPPER}} .comment-author img' => 'text-align: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);
		$this->end_controls_section(); //end single post comment section
		//style section after single post comment section.
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'elementpress' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		//typograpghy control inside style section
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'elementpress' ),
				'scheme' => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .coment_list div',
			]
		);
		//background-color (color picker) control inside style section
		$this->add_control(
        	'background_color',
        	[
        		'label' => __( 'Background Color', 'elementpress' ),
        		'type' => Controls_Manager::COLOR,
				'default' => '#000',
        		'selectors' => [
        			'{{WRAPPER}} .coment_list div' => 'background-color: {{VALUE}}',
        		],
        	]
		);
			//title-color (color picker) control inside style section
		$this->add_control(
        	'Title_color',
        	[
        		'label' => __( 'Title Color Text', 'elementpress' ),
        		'type' => Controls_Manager::COLOR,
				'default' => '#000',
        		'selectors' => [
        			'{{WRAPPER}} .comment-author b,{{WRAPPER}} .comment-author b a' => 'color: {{VALUE}}',
        		],
        	]
		);
			//content-color (color picker) control inside style section
         $this->add_control(
        	'content_color',
        	[
        		'label' => __( 'Content Color Text', 'elementpress' ),
        		'type' => Controls_Manager::COLOR,
				'default' => '#000',
        		'selectors' => [
        			'{{WRAPPER}} .coment_list p' => 'color: {{VALUE}}',
        		],
        	]
		);
			//meta-color (color picker) control inside style section
		$this->add_control(
        	'meta_color',
        	[
        		'label' => __( 'Meta Color Text', 'elementpress' ),
        		'type' => Controls_Manager::COLOR,
				'default' => '#000',
        		'selectors' => [
        			'{{WRAPPER}} .comment-metadata a' => 'color: {{VALUE}}',
        		],
        	]
		);
			//meta-color hover (color picker) control inside style section
		$this->add_control(
        	'meta_color_hover',
        	[
        		'label' => __( 'Meta Color Hover', 'elementpress' ),
        		'type' => Controls_Manager::COLOR,
        	  'default' => '#000',
        		'selectors' => [
        			'{{WRAPPER}} .comment-metadata a:hover' => 'color: {{VALUE}}',
        		],
        	]
		);
		//responsive margin control inside style section
		$this->add_responsive_control(
			'margin',
			[
				'label' => __( 'Margin', 'elementpress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .comment-author img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		//responsive border radius control inside style section
		$this->add_control(
        	'border_radius',
        	[
        		'label' => __( 'Image Border Radius', 'elementpress' ),
        		'type' => Controls_Manager::DIMENSIONS,
        		'size_units' => [ 'px', '%' ],
        		'selectors' => [
        			'{{WRAPPER}} .comment-author img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        		],
        	]
		);
		//responsive image padding control inside style section
		$this->add_responsive_control(
			'image_padding',
			[
				'label' => __( 'Padding', 'elementpress' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .comment-author img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section(); //end style section
	}
	//front end rendering
    protected function render() {
		$settings = $this->get_settings_for_display();
		$coments_per_page=$settings['per_page_coment'];
		$coment_page=$settings['coment_page_ref'];
		if($settings['show_reply']=='yes')
		{
			$show='Reply';
		}
		else
		{
			$show='';
		}
        $current_page = sanitize_post( $GLOBALS['wp_the_query']->get_queried_object() );
		if(isset($current_page) && !empty($current_page))
		{
		// Get the page slug
 			$slug = $current_page->post_name;
		}
		else{
			$slug = '';
		}
$args = array(
    'name'        => $slug,
    'post_type'   => 'post',
    'post_status' => 'publish',
    'numberposts' => 1
  );
  $my_posts = get_posts($args);
  if(isset($my_posts) && !empty($my_posts))
  {
  // Get the page slug
  $post = $my_posts[0];
  }
  else{
	  $post = '';
  }
  foreach($my_posts as $post){
	$args = array(
		'walker'            => null,
		'max_depth'         => '',
		'style'             => 'div',
		'callback'          => null,
		'end-callback'      => null,
		'type'              => 'none',
		'reply_text'        => $show,
		'page'              => $coment_page,
		'per_page'          => $coments_per_page,
		'avatar_size'       => 32,
		'reverse_top_level' => null,
		'reverse_children'  => '',
		'format'            => 'html5', // or 'xhtml' if no 'HTML5' theme support
		'short_ping'        => false,   // @since 3.6
			'echo'              => true     // boolean, default is true
	);?>
	<div class="coment_list" >
	<?php
	$comments = get_comments( array( $post->ID ));
	wp_list_comments( $args, $comments );
	?>
</div>
    <?php
  }
}
    protected function content_template() { }
}