<?php
/**
 * @author : Jegtheme
 */

namespace EPRESS\Module\Post;

use EPRESS\Module\ModuleOptionAbstract;

Class Post_Sequence_Option extends ModuleOptionAbstract {
	public function get_category() {
		return esc_html__( 'EPRESS - Post', 'elementpress' );
	}

	public function compatible_column() {
		return array( 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 );
	}

	public function get_module_name() {
		return esc_html__( 'ElementPress - Post Next Prev', 'elementpress' );
	}

	public function set_options() {
		$this->options[] = array(
			'type'        => 'dropdown',
			'param_name'  => 'style',
			'heading'     => esc_html__( 'Nav Style', 'elementpress' ),
			'description' => esc_html__( 'Choose navigation style for post prev next element.', 'elementpress' ),
			'group'       => esc_html__( 'Design', 'elementpress' ),
			'default'     => 'style_1',
			'value'       => array(
				esc_html__( 'Style 1', 'elementpress' ) => 'style_1',
				esc_html__( 'Style 2', 'elementpress' ) => 'style_2',
				esc_html__( 'Style 3', 'elementpress' ) => 'style_3'
			)
		);

		$this->options[] = array(
			'type'        => 'colorpicker',
			'param_name'  => 'border_color',
			'heading'     => esc_html__( 'Border Color', 'elementpress' ),
			'description' => esc_html__( 'Set left border color.', 'elementpress' ),
			'group'       => esc_html__( 'Design', 'elementpress' ),
			'dependency'  => array( 'element' => 'style', 'value' => 'style_1' )
		);

		$this->options[] = array(
			'type'        => 'colorpicker',
			'param_name'  => 'border_color_hover',
			'heading'     => esc_html__( 'Border Color Hover', 'elementpress' ),
			'description' => esc_html__( 'Set left border color hover.', 'elementpress' ),
			'group'       => esc_html__( 'Design', 'elementpress' ),
			'dependency'  => array( 'element' => 'style', 'value' => 'style_1' )
		);

		$this->options[] = array(
			'type'        => 'textfield',
			'param_name'  => 'nav_font_size',
			'heading'     => esc_html__( 'Nav Text Font Size', 'elementpress' ),
			'description' => esc_html__( 'Set font size with unit (Ex: 36px or 4em) for nav text.', 'elementpress' ),
			'group'       => esc_html__( 'Design', 'elementpress' ),
		);

		$this->options[] = array(
			'type'        => 'colorpicker',
			'param_name'  => 'nav_color',
			'heading'     => esc_html__( 'Nav Text Color', 'elementpress' ),
			'description' => esc_html__( 'Set nav text color.', 'elementpress' ),
			'group'       => esc_html__( 'Design', 'elementpress' ),
		);

		$this->options[] = array(
			'type'        => 'textfield',
			'param_name'  => 'title_font_size',
			'heading'     => esc_html__( 'Post Title Font Size', 'elementpress' ),
			'description' => esc_html__( 'Set font size with unit (Ex: 36px or 4em) for post title.', 'elementpress' ),
			'group'       => esc_html__( 'Design', 'elementpress' ),
		);

		$this->options[] = array(
			'type'        => 'colorpicker',
			'param_name'  => 'title_color',
			'heading'     => esc_html__( 'Post Title Color', 'elementpress' ),
			'description' => esc_html__( 'Set post title text color.', 'elementpress' ),
			'group'       => esc_html__( 'Design', 'elementpress' ),
		);

		$this->set_style_option();
	}

	public function set_typography_option( $instance ) {

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Title Typography', 'elementpress' ),
				'selector' => '{{WRAPPER}} .post-title',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'nav_typography',
				'label'    => esc_html__( 'Nav Text Typography', 'elementpress' ),
				'selector' => '{{WRAPPER}} .jeg_prevnext_post .caption',
			]
		);
	}
}
