<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS\Module\Post;

use EPRESS\Module\ModuleOptionAbstract;

Class Post_Related_Option extends ModuleOptionAbstract
{
    public function get_category()
    {
        return esc_html__('EPRESS - Post', 'elementpress');
    }

    public function compatible_column()
    {
        return array( 1,2,3,4,5,6,7,8,9,10,11,12 );
    }

    public function get_module_name()
    {
        return esc_html__('ElementPress - Related Post', 'elementpress');
    }

    public function set_options()
    {
        $this->set_post_option();
        $this->set_style_option();
    }

    public function set_post_option()
    {
	    $this->options[] = array(
		    'type'          => 'textfield',
		    'param_name'    => 'first_title',
		    'heading'       => esc_html__('First Title', 'elementpress'),
		    'description'   => esc_html__('Insert text for first title.', 'elementpress'),
		    'std'           => esc_html__( 'Related', 'elementpress' )
	    );

	    $this->options[] = array(
		    'type'          => 'textfield',
		    'param_name'    => 'second_title',
		    'heading'       => esc_html__('Second Title', 'elementpress'),
		    'description'   => esc_html__('Insert text for second title.', 'elementpress'),
		    'std'           => esc_html__( ' Posts', 'elementpress' )
	    );

        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'match',
            'heading'       => esc_html__('Related Post Filter', 'elementpress'),
            'description'   => esc_html__('Select how related post will filter article.','elementpress'),
            'std'           => '',
            'value'         => array(
                esc_html__('Category', 'elementpress') => 'category',
                esc_html__('Tag', 'elementpress')      => 'tag',
            )
        );

        $this->options[] = array(
            'type'          => 'radioimage',
            'param_name'    => 'header_type',
            'std'           => 'heading_6',
            'value'         => array(
               EPRESS_URL . '/assets/img/admin/heading-1.png'  => 'heading_1',
               EPRESS_URL . '/assets/img/admin/heading-2.png'  => 'heading_2',
               EPRESS_URL . '/assets/img/admin/heading-3.png'  => 'heading_3',
               EPRESS_URL . '/assets/img/admin/heading-4.png'  => 'heading_4',
               EPRESS_URL . '/assets/img/admin/heading-5.png'  => 'heading_5',
               EPRESS_URL . '/assets/img/admin/heading-6.png'  => 'heading_6',
               EPRESS_URL . '/assets/img/admin/heading-7.png'  => 'heading_7',
               EPRESS_URL . '/assets/img/admin/heading-8.png'  => 'heading_8',
               EPRESS_URL . '/assets/img/admin/heading-9.png'  => 'heading_9',
            ),
            'heading'       => esc_html__('Header Type', 'elementpress'),
            'description'   => esc_html__('Choose which header type fit with your content design.', 'elementpress'),
        );

        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'pagination',
            'heading'       => esc_html__('Related Pagination Style', 'elementpress'),
            'description'   => esc_html__('Adjust how related post will shown.','elementpress'),
            'std'           => '',
            'value'         => array(
                esc_html__('No Pagination', 'elementpress')        => 'disable',
                esc_html__('Next Prev', 'elementpress')            => 'nextprev',
                esc_html__('Load More', 'elementpress')            => 'loadmore',
                esc_html__('Auto Load on Scroll', 'elementpress')  => 'scrollload',
            )
        );

        $this->options[] = array(
            'type'          => 'slider',
            'param_name'    => 'number',
            'heading'       => esc_html__('Number of Post', 'elementpress'),
            'description'   => esc_html__('Set the number of post each related post load.', 'elementpress'),
            'min'           => 2,
            'max'           => 10,
            'step'          => 1,
            'std'           => 5,
        );

        $this->options[] = array(
            'type'          => 'slider',
            'param_name'    => 'auto_load',
            'heading'       => esc_html__('Auto Load Limit', 'elementpress'),
            'description'   => esc_html__('Limit of auto load when scrolling, set to zero to always load until end of content.', 'elementpress'),
            'min'           => 0,
            'max'           => 500,
            'step'          => 1,
            'std'           => 3,
            'dependency'    => array('element' => 'pagination', 'value' => array('nextprev', 'loadmore', 'scrollload'))
        );

        $this->options[] = array(
            'type'          => 'radioimage',
            'param_name'    => 'template',
            'std'           => '9',
            'value'         => array(
               EPRESS_URL . '/assets/img/admin/content-1.png' => '1' ,
               EPRESS_URL . '/assets/img/admin/content-2.png' => '2' ,
               EPRESS_URL . '/assets/img/admin/content-3.png' => '3' ,
               EPRESS_URL . '/assets/img/admin/content-4.png' => '4' ,
               EPRESS_URL . '/assets/img/admin/content-5.png' => '5' ,
               EPRESS_URL . '/assets/img/admin/content-6.png' => '6' ,
               EPRESS_URL . '/assets/img/admin/content-7.png' => '7' ,
               EPRESS_URL . '/assets/img/admin/content-8.png' => '8' ,
               EPRESS_URL . '/assets/img/admin/content-9.png' => '9' ,
               EPRESS_URL . '/assets/img/admin/content-10.png' => '10',
               EPRESS_URL . '/assets/img/admin/content-11.png' => '11',
               EPRESS_URL . '/assets/img/admin/content-12.png' => '12',
               EPRESS_URL . '/assets/img/admin/content-13.png' => '13',
               EPRESS_URL . '/assets/img/admin/content-14.png' => '14',
               EPRESS_URL . '/assets/img/admin/content-15.png' => '15',
               EPRESS_URL . '/assets/img/admin/content-16.png' => '16',
               EPRESS_URL . '/assets/img/admin/content-17.png' => '17',
               EPRESS_URL . '/assets/img/admin/content-18.png' => '18',
               EPRESS_URL . '/assets/img/admin/content-19.png' => '19',
               EPRESS_URL . '/assets/img/admin/content-20.png' => '20',
               EPRESS_URL . '/assets/img/admin/content-21.png' => '21',
               EPRESS_URL . '/assets/img/admin/content-22.png' => '22',
               EPRESS_URL . '/assets/img/admin/content-23.png' => '23',
               EPRESS_URL . '/assets/img/admin/content-24.png' => '24',
               EPRESS_URL . '/assets/img/admin/content-25.png' => '25',
               EPRESS_URL . '/assets/img/admin/content-26.png' => '26',
               EPRESS_URL . '/assets/img/admin/content-27.png' => '27',
            ),
            'heading'       => esc_html__('Related PostTemplate', 'elementpress'),
            'description'   => esc_html__('Choose your related post template.', 'elementpress'),
        );

        $this->options[] = array(
            'type'          => 'slider',
            'param_name'    => 'excerpt',
            'heading'       => esc_html__('Excerpt Length', 'elementpress'),
            'description'   => esc_html__('Set word length of excerpt on related post.', 'elementpress'),
            'min'           => 0,
            'max'           => 200,
            'step'          => 1,
            'std'           => 20,
        );

        $this->options[] = array(
            'type'          => 'dropdown',
            'param_name'    => 'date',
            'heading'       => esc_html__('Related Post Date Format', 'elementpress'),
            'description'   => esc_html__('Choose which date format you want to use for archive content.','elementpress'),
            'std'           => 'default',
            'value'         => array(
                 esc_attr__( 'Relative Date/Time Format (ago)', 'elementpress' ) => 'ago',
                 esc_attr__( 'WordPress Default Format', 'elementpress' ) => 'default',
                 esc_attr__( 'Custom Format', 'elementpress' ) => 'custom',
            )
        );

        $this->options[] = array(
            'type'          => 'textfield',
            'param_name'    => 'date_custom',
            'heading'       => esc_html__('Custom Date Format for Related Post', 'elementpress'),
            'description'   => wp_kses(sprintf(__("Please set your date format for related post content, for more detail about this format, please refer to
                        <a href='%s' target='_blank'>Developer Codex</a>.", 'elementpress'), "https://developer.wordpress.org/reference/functions/current_time/"),
                wp_kses_allowed_html()),
            'std'       => 'Y/m/d',
        );
    }

	public function set_typography_option( $instance ) {

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'title_typography',
				'label'       => esc_html__( 'Title Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post title', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_title > a,{{WRAPPER}} .jeg_block_title',
			]
		);

		$instance->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'meta_typography',
				'label'       => esc_html__( 'Meta Typography', 'elementpress' ),
				'description' => esc_html__( 'Set typography for post meta', 'elementpress' ),
				'selector'    => '{{WRAPPER}} .jeg_post_meta, {{WRAPPER}} .jeg_post_meta .fa, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a:hover, {{WRAPPER}} .jeg_pl_md_card .jeg_post_category a, {{WRAPPER}}.jeg_postblock .jeg_subcat_list > li > a.current, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta, {{WRAPPER}} .jeg_pl_md_5 .jeg_post_meta .fa, {{WRAPPER}} .jeg_post_category a',
			]
		);
	}
}
