<?php
/**
 * @author : Jegtheme
 */
namespace EPRESS;

use EPRESS\Module\ModuleManager;

/**
 * Class Frontend Ajax
 */
Class Asset
{
    /**
     * @var FrontendAjax
     */
    private static $instance;
    /**
     * @return FrontendAjax
     */
    public static function getInstance()
    {
        if (null === static::$instance)
        {
            static::$instance = new static();
        }
        return static::$instance;
    }

    /**
     * FrontendAjax constructor.
     */
    private function __construct()
    {
    
        add_action( 'wp_enqueue_scripts', array($this, 'load_style'), 98);
        add_action( 'wp_enqueue_scripts', array($this, 'load_script'), 98);

  
    }

    public function is_login_page()
    {
        return in_array($GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php'));
    }




    public function load_style()
    {
        if(!$this->is_login_page())
        {
            $css_url = EPRESS_URL . '/assets/css/';
            $font_url = EPRESS_URL . '/assets/fonts/';

            // font
            wp_enqueue_style('epress-icon', $font_url . 'jegicon/jegicon.css');
            wp_enqueue_style('font-awesome', $font_url . 'font-awesome/font-awesome.min.css');

            // Style
            wp_enqueue_style('epress-style', $css_url . 'style.min.css');
        }
    }

    public function load_script()
    {
        if(!$this->is_login_page())
        {
            $js_url = EPRESS_URL . '/assets/js/';

            wp_enqueue_script( 'wp-mediaelement' );
            wp_enqueue_script( 'imagesloaded' );

            wp_enqueue_script('epress-script', $js_url . 'script.min.js', null, null, true);
            wp_localize_script('epress-script', 'epressoption', $this->localize_script());
        }
    }

    public function localize_script()
    {
        $option['prefix'] = ModuleManager::$module_ajax_prefix;
        $option['rtl'] = is_rtl() ? 1 : 0;

        if(is_admin_bar_showing())
        {
            if(function_exists('vc_is_page_editable') && vc_is_page_editable())
            {
                $option['admin_bar'] = 0;
            } else {
                $option['admin_bar'] = 1;
            }
        } else {
            $option['admin_bar'] = 0;
        }

        return $option;
    }
}
