<?php

namespace Elementor;

use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;



if ( ! defined( 'ABSPATH' ) ) exit;

class Epress_search extends Widget_Base {

    public $base;

    

    public function __construct($data = [], $args = null) {

		parent::__construct($data, $args);







        wp_register_style( 'epress-search-css',  \ElementPress::widgets_url() . '/epress-search/assets/epress-search.css', false, \ElementPress::version );

  

     }

  

	  public function get_style_depends() {

		 

		 return [ 'epress-search-css' ];

	  }



    public function get_name() {

        //get name from search-handler.php file

        return 'epress-search';

    }

    public function get_title() {

        //get title from search-handler.php file

        return esc_html__( 'Epress Search', 'elementpress' );

    }

    public function get_icon() {

        //get icon from search-handler.php file

        return 'eicon-search-bold';

    }

    public function get_categories() {

        //get categories from search-handler.php file

        return [ 'elementpress_singlepost' ];

    }

    //register controls

    protected function register_controls() {

        //search section inside search widget

        $this->start_controls_section(

			'content_section',

			[

				'label' => __( 'Search', 'elementpress' ),

				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,

			]

        );



        $this->add_group_control(

			Group_Control_Border::get_type(),

			[

				'name' => 'border',

				'label' => __( 'Border', 'elementpress' ),

				'selector' => '.elementpress-search-filed',

			]

		);



        $this->add_responsive_control(

			'input_field_padding',

			[

				'label' => __( 'Input-Field-Padding', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'.elementpress-search-filed' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',

				],

			]

        );

        

        $this->add_control(

			'margin',

			[

				'label' => __( 'Input-Field-Margin', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', '%', 'em' ],

				'selectors' => [

					'.elementpress-search-filed' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

        );



        $this->add_control(

			'input-border_radius',

			[

				'label' => __( 'Input-Border-Radius', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', '%', 'em' ],

				'selectors' => [

					'.elementpress-search-filed' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important',

				],

			]

		);

        

		$this->add_group_control(

			Group_Control_Box_Shadow::get_type(),

			[

				'name' => 'box_shadow',

				'label' => __( 'Box Shadow', 'elementpress' ),

				'selector' => '.elementpress-search-filed',

			]

		);



        $this->add_control(

			'switch-control',

			[

				'label' => __( 'Show Icon', 'elementpress' ),

				'type' => Controls_Manager::SWITCHER,

				'label_on' => __( 'Show', 'elementpress' ),

				'label_off' => __( 'Hide', 'elementpress' ),

				'return_value' => 'yes',

				'default' => 'yes',

            ]

            

		);



        $this->add_control(

			'icon',

			[

				'label' => __( 'Button Icon', 'elementpress' ),

				'type' => Controls_Manager::ICONS,

				'default' => [

					'value' => 'fas fa-star',

					'library' => 'solid',

                ],

                'condition' => [

                    'switch-control' => 'yes'

                ],

			]

        );



        $this->add_group_control(

            Group_Control_Typography::get_type(),

            [

                'name' => 'content_typography',

                'label' => __( 'Button_Typography', 'elementpress' ),

                'scheme' => Scheme_Typography::TYPOGRAPHY_1,

                'selector' => '{{WRAPPER}} .elementpress-search-btn',

                'condition' => [

                    'switch-control' => 'no'

                ],

            ]

        );



        $this->add_control(

            'border_radius_search_btn',

            [

                'label'     => __( 'Button Border Radius', 'elementpress' ),

                'type'      => Controls_Manager::SLIDER,

                'default'   => [

                    'size' => 0,

                ],

                'range'     => [

                    'px' => [

                        'min' => 0,

                        'max' => 200,

                    ],

                ],

                'selectors' => [

                    '.elementpress-search-btn' => 'border-radius: {{SIZE}}{{UNIT}}',

                ],

            ]

        );

        $this->add_responsive_control(

			'Button_Padding',

			[

				'label' => __( 'Button-Padding', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', 'em', '%' ],

				'selectors' => [

					'.elementpress-search-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',

				],

			]

        );

        $this->add_control(

			'Button_margin',

			[

				'label' => __( 'Button-Margin', 'elementpress' ),

				'type' => Controls_Manager::DIMENSIONS,

				'size_units' => [ 'px', '%', 'em' ],

				'selectors' => [

					'.elementpress-search-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],

			]

        );

      

        $this->add_control(

            'search_btn_background_color',

            [

                'label'     => __( 'Button Background Color', 'elementpress' ),

                'type'      => Controls_Manager::COLOR,

                'scheme'    => [

                    'type'  => \Elementor\Core\Schemes\Color::get_type(),

                    'value' => \Elementor\Core\Schemes\Color::COLOR_1,

                ],

                

                'selectors' => [

                    '.elementpress-search-btn' => 'background-color: {{VALUE}};',

                ],

            ]

        );

        $this->add_control(

            'search_btn_icon_color',

            [

                'label'     => __( 'Icon Color', 'elementpress' ),

                'type'      => Controls_Manager::COLOR,

                'scheme'    => [

                    'type'  => \Elementor\Core\Schemes\Color::get_type(),

                    'value' => \Elementor\Core\Schemes\Color::COLOR_2,

                ],

                

                'selectors' => [

                    '.elementpress-search-btn' => 'color: {{VALUE}};',

                ],

            ]

        );

        $this->add_control(

			'position_for_btn',

			[

				'label' => __( 'Button Position', 'elementpress' ),

				'label_block' => true,

				'type' => Controls_Manager::SELECT,

				'multiple' => true,

				'default' =>__( 'Select position' , 'elementpress' ),

				'options' => [					

                    'relative' => __( 'Relative', 'elementpress' ),

                    'absolute' => __( 'Absolute', 'elementpress' ),

					'fixed' => __( 'Fixed', 'elementpress' ),



				],

				//'separator' => 'before',

			]

		);



		//top slider control

		$this->add_control(

			'position_for_btn_top',

			[

				'label' => __( 'TOP', 'elementpress' ),

				'type' => Controls_Manager::NUMBER,

                'min' => 0,

                'default' =>0,

				'selectors' => [

					'{{WRAPPER}}  .elementpress-search-btn ' => 'top: {{VALUE}}px;',

				],

			]

		);

		

	

		$this->add_control(

			'position_for_btn_right',

			[

				'label' => __( 'RIGHT', 'elementpress' ),

                'type' => Controls_Manager::NUMBER,

                'min' => 0,

				'default' =>0,

				'selectors' => [

					'{{WRAPPER}}  .elementpress-search-btn ' => 'right: {{VALUE}}px;',

				],

			]

		);

		

		

		$this->add_control(

			'position_for_btn_left',

			[

				'label' => __( 'LEFT', 'elementpress' ),

				'type' => Controls_Manager::NUMBER,

                'min' => 0,

                'default' =>'',

				'selectors' => [

					'{{WRAPPER}}  .elementpress-search-btn ' => 'left: {{VALUE}}px;',

				],

			]

		);

		

		

		$this->add_control(

			'position_for_btn_bottom',

			[

				'label' => __( 'BOTTOM', 'elementpress' ),

				'type' => Controls_Manager::NUMBER,

                'min' => 0,

                'default' =>'',

				'selectors' => [

					'{{WRAPPER}}  .elementpress-search-btn' => 'bottom: {{VALUE}}px;',

				],

			]

		);

        

        

        $this->end_controls_section();

        

    }

    //front end rendering

    protected function render() {



        

        $settings = $this->get_settings_for_display();

        $unique_id = esc_attr( self::wp_get_unique_id( 'elementpress-search-form-' ) );

        ?>

       <form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">

       <label for="<?php echo $unique_id; ?>" class="elementpress-searchbox-label"></label>

    <div class="elementpress-searchbox">                     

                                <input type="text" class="elementpress-search-filed" placeholder="What are you looking for?" value="<?php echo get_search_query(); ?>" name="s">

                                <button class ="elementpress-search-btn epres-<?=$settings['position_for_btn'];?>" type="submit"> <?php if($settings['switch-control']==="yes"){\Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] );}else{echo 'Search';} ?></button>  

                    </div>

                </form>

            

        <?php

        

}

function wp_get_unique_id( $prefix = '' ) {

	static $id_counter = 0;

	if ( function_exists( 'wp_unique_id' ) ) {

		return wp_unique_id( $prefix );

	}

	return $prefix . (string) ++$id_counter;

}

    protected function content_template() { }

}