<?php


namespace Elementor;

use \Elementor\Controls_Manager;
use Elementor\Core\Schemes\Typography as Scheme_Typography;
Use Elementor\Core\Schemes\Color as Scheme_Color;


if (!defined('ABSPATH')) exit;

class Epress_heading extends Widget_Base
{

    public $base;

    public function get_name()
    {

        //get name from price-handler file

        return 'elementpress-custom-heading';

    }

    public function get_title()
    {

        //get title from price-handler file

        return esc_html__('Epress Heading', 'elementpress');

    }

    public function get_icon()
    {

        //get icon from price-handler file

        return 'eicon-t-letter';

    }

    public function get_categories()
    {

        //get category where widget will be added in elementor front end

        return ['additional-addons'];

    }

// elementor default function to register your controls

    protected function register_controls()
    {

//  Content Section Dual Heading Start

        $this->start_controls_section(

        //section which is shown after you drage your widget in the fornt-end area

            'section_content',

            [

                'label' => __('Epress Heading', 'additional-addons'),//......

            ]

        );

// adding input text field named From.

        $this->add_control(

            'heading',

            [

                'label' => __('Custom Heading', 'elementpress'),

                'type' => Controls_Manager::SELECT,

                'default' => 'h1',

                'options' => [

                    'h1' => __('H1', 'elementpress'),

                    'h2' => __('H2', 'elementpress'),

                    'h3' => __('H3', 'elementpress'),

                    'h4' => __('H4', 'elementpress'),

                    'h5' => __('H5', 'elementpress'),

                    'h6' => __('H6', 'elementpress'),

                ],

            ]

        );

        $this->add_control(

            'text_align',

            [

                'label' => __('Heading Alignment', 'elementpress'),

                'type' => Controls_Manager::CHOOSE,

                'options' => [

                    'left' => [

                        'title' => __('Left', 'elementpress'),

                        'icon' => 'fa fa-align-left',

                    ],

                    'center' => [

                        'title' => __('Center', 'elementpress'),

                        'icon' => 'fa fa-align-center',

                    ],

                    'right' => [

                        'title' => __('Right', 'elementpress'),

                        'icon' => 'fa fa-align-right',

                    ],

                ],

                'default' => 'center',

                'toggle' => true,

                'selector' => '.custom-class',

            ]


        );


// adding input text named Price.

        $this->add_control(

            'Text_Area',

            [

                'label' => __('Content ', 'additional-addons'),

                'type' => Controls_Manager::TEXT,

                'rows' => 10,

                'default' => __('hello world!', 'additional-addons'),


            ]

        );


        $this->add_control(

            'color',

            [

                'label' => __('Color', 'elementpress'),

                'type' => Controls_Manager::COLOR,

                'scheme' => [

                    'type' => Scheme_Color::get_type(),

                    'value' => Scheme_Color::COLOR_1,

                ],

                'selectors' => [

                    '.custom-class' => 'color: {{VALUE}}',

                    '.custom-class1' => 'color: {{VALUE}}',

                ],

            ]

        );


        $this->add_group_control(

            Group_Control_Typography::get_type(),

            [

                'name' => 'content_typography',

                'label' => __('Typography', 'elementpress'),

                'scheme' => Scheme_Typography::TYPOGRAPHY_1,

                'selector' => '.custom-class',

            ]

        );


        $this->add_control(

            'item_description',

            [

                'label' => __('Description', 'elementpress'),

                'type' => Controls_Manager::WYSIWYG,

                'rows' => 15,

                'default' => __('Default description', 'elementpress'),

                'placeholder' => __('Type your description here', 'elementpress'),

                'selector' => '.custom-class1',

            ]

        );

        $this->add_control(

            'text_align1',

            [

                'label' => __('Description Alignment', 'elementpress'),

                'type' => Controls_Manager::CHOOSE,

                'options' => [

                    'left' => [

                        'title' => __('Left', 'elementpress'),

                        'icon' => 'fa fa-align-left',

                    ],

                    'center' => [

                        'title' => __('Center', 'elementpress'),

                        'icon' => 'fa fa-align-center',

                    ],

                    'right' => [

                        'title' => __('Right', 'elementpress'),

                        'icon' => 'fa fa-align-right',

                    ],

                ],

                'default' => 'center',

                'toggle' => true,

                'selector' => '.custom-class1',

            ]


        );

        $this->add_group_control(

            Group_Control_Typography::get_type(),

            [

                'name' => 'content1_typography',

                'label' => __('Description Typography', 'elementpress'),

                'scheme' => Scheme_Typography::TYPOGRAPHY_1,

                'selector' => '.custom-class1',

            ]

        );

        $this->add_control(

            'image',

            [

                'label' => __('Choose Image', 'elementpress'),

                'type' => Controls_Manager::MEDIA,

                'default' => [

                    'url' => Utils::get_placeholder_image_src(),

                ],

            ]

        );


        $this->add_control(

            'custom_dimension',

            [

                'label' => __('Image Dimension', 'elementpress'),

                'type' => Controls_Manager::IMAGE_DIMENSIONS,

                'description' => __('Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.', 'elementpress'),

                'default' => [

                    'width' => '',

                    'height' => '',

                ],

                'selector' => '.custom-class2',

            ]

        );


        $this->add_control(

            'text_align2',

            [

                'label' => __('Description Alignment', 'elementpress'),

                'type' => \Elementor\Controls_Manager::CHOOSE,

                'options' => [

                    'left' => [

                        'title' => __('Left', 'elementpress'),

                        'icon' => 'fa fa-align-left',

                    ],

                    'center' => [

                        'title' => __('Center', 'elementpress'),

                        'icon' => 'fa fa-align-center',

                    ],

                    'right' => [

                        'title' => __('Right', 'elementpress'),

                        'icon' => 'fa fa-align-right',

                    ],

                ],

                'default' => 'center',

                'toggle' => true,

                'selector' => '.custom-class2',

            ]


        );


        $this->end_controls_section();

    }

    /**
     * Render the Dual Heading And Dual Button widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */

//function to show how front end will look like after you change settings in price widget

//front end live preview.

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        // echo "<pre>";
        // echo print_r($settings['image']['alt']);
        // die;
      
        ?>


        <<?php echo $settings['heading'] ?> class="custom-class" style="color:<?= $settings['color'] ?>;text-align:<?= $settings['text_align'] ?>">  <?php echo $settings['Text_Area'] . '<br>' ?>  </<?php echo $settings['heading'] ?>>

        <div class="custom-class1"
             style="color:<?= $settings['color'] ?>;text-align:<?= $settings['text_align1'] ?>"> <?php echo $settings['item_description'] ?> </div>

    <div class="custom-class2" style="text-align:<?= $settings["text_align2"] ?>"><img alt="<?=$settings['image']['alt']?>"
        style="width:<?= $settings['custom_dimension']['width'] ?>px;height:<?= $settings['custom_dimension']['height'] ?>px;"
        src=" <?php echo $settings['image']['url'] . '">'; ?></div>

    

        <?php

    }

    /**
     * Render the widget output in the editor.
     *
     * Written as a Backbone JavaScript template and used to generate the live preview.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    protected function content_template()
    {

    }

}

